//----------------------------------------------------------------------------
//  Project Combined
//  University of Mannheim
//  Copyright  1996. All Rights Reserved
//
//  SUBSYSTEM:    Combined Application
//  FILE:         cmbndwnd.cpp
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TCombinedWindow (TWindow).
//
//----------------------------------------------------------------------------

#include <owl/pch.h>

#include "cmbndapp.h"

#include "cmbndwnd.h"

#include <stdio.h>


//
// Build a response table for all messages/commands handled by the application.
//
DEFINE_RESPONSE_TABLE1(TCombinedWindow, TWindow)
//{{TCombinedWindowRSP_TBL_BEGIN}}
  EV_COMMAND(CM_MENUITEM1, CmMenuitem1),
  EV_COMMAND(CM_MENUITEM2, CmMenuitem2),
  EV_COMMAND(CM_MENUITEM3, CmMenuitem3),
  EV_COMMAND(CM_MENUITEM4, CmMenuitem4),
  EV_WM_RBUTTONDOWN,
//{{TCombinedWindowRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{TCombinedWindow Implementation}}


//--------------------------------------------------------
// TCombinedWindow
// ~~~~~~~~~~
// Construction/Destruction handling.
//
TCombinedWindow::TCombinedWindow(TWindow* parent, const char far* title, TModule* module)
:
  TWindow(parent, title, module)
{
  // INSERT>> Your constructor code here.

  pSubMenuRect = new TRect(0,0,0,0);
  pDynMenuRect = new TRect(0,0,0,0);
  pDynRespRect = new TRect(0,0,0,0);
  pNoRespRect  = new TRect(0,0,0,0);

}


TCombinedWindow::~TCombinedWindow()
{
  Destroy();

  delete (pSubMenuRect);
  delete (pDynMenuRect);
  delete (pDynRespRect);
  delete (pNoRespRect);
}

void TCombinedWindow::CmMenuitem1()
{
  // INSERT>> Your code here.
  MessageBox ("You've selected Menuitem 1","Combined");
}


void TCombinedWindow::CmMenuitem2()
{
  // INSERT>> Your code here.
 MessageBox ("You've selected Menuitem 2","Combined");
}


void TCombinedWindow::CmMenuitem3()
{
  // INSERT>> Your code here.
 MessageBox ("You've selected Menuitem 3","Combined");
}
void TCombinedWindow::CmMenuitem4()
{
  // INSERT>> Your code here.
 MessageBox ("You've selected Menuitem 4","Combined");
}
void TCombinedWindow::CmMenuitem5()
{
  // INSERT>> Your code here.
 MessageBox ("You've selected Menuitem 5","Combined");
}
void TCombinedWindow::CmMenuitem6()
{
  // INSERT>> Your code here.
 MessageBox ("You've selected Menuitem 6","Combined");
}


void TCombinedWindow::EvRButtonDown(uint modKeys, TPoint& point)

//for demonstration purposes this code is held inefficiently

{
 TWindow::EvRButtonDown(modKeys, point);

  // INSERT>> Your code here.
  if (pSubMenuRect->Contains(point))
  {
   //Get the handle of the frame window owning the main menu
   HWND HFrame = *GetApplication()->GetMainWindow();
   //Get the main menu
   TMenu* pMenu           = new TMenu(HFrame);
   //extract a the submenu, that should become the context menu
   TMenu* pContextMenu        = new TMenu(pMenu->GetSubMenu(1));
   //create the conext menu
   TPopupMenu* pPopupMenu  = new TPopupMenu(*pContextMenu);

   ClientToScreen(point);
   // send menu messages to the main window allow menu tracking to work seemlessly
   pPopupMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point, 0, HFrame, 0);

   delete pPopupMenu;
   delete pContextMenu;
   delete pMenu;
  }
  else
   if (pDynMenuRect->Contains(point))
   {
    //Get the handle of the frame window
    HWND HFrame = *GetApplication()->GetMainWindow();
    
    //create an empty popup menu
    TPopupMenu* pPopupMenu  = new TPopupMenu();

    //Insert some items
    pPopupMenu->AppendMenu (MF_STRING,CM_MENUITEM3,"Menuitem 3");
    pPopupMenu->AppendMenu (MF_STRING,CM_MENUITEM4,"Menuitem 4");

    ClientToScreen(point);
    // send menu messages to the main window allow menu tracking to work seemlessly
    pPopupMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point, 0, HFrame, 0);

    delete pPopupMenu;
   }
   else
    if (pDynRespRect->Contains (point))
    {
     //Get the handle of the frame window
     HWND HFrame = *GetApplication()->GetMainWindow();

     //create an empty popup menu
     TPopupMenu* pPopupMenu  = new TPopupMenu();

     //Insert some items
     pPopupMenu->AppendMenu (MF_STRING,CM_MENUITEM5,"Menuitem 5");
     pPopupMenu->AppendMenu (MF_STRING,CM_MENUITEM6,"Menuitem 6");
     pPopupMenu->EnableMenuItem (CM_MENUITEM5,true);

     ClientToScreen(point);
     // send menu messages to the main window allow menu tracking to work seemlessly
     pPopupMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point, 0, HFrame, 0);

     delete pPopupMenu;
    }
    else
     MessageBox ("No Context Menu for this area","Combined");
}


void TCombinedWindow::Paint(TDC& DC, bool erase, TRect& rect)
{
  TWindow::Paint(DC, erase, rect);

  // INSERT>> Your code here.
  int iHalfH = Attr.Y + Attr.H/2;
  int iHalfW = Attr.X + Attr.W/2;

  pSubMenuRect->Set(0,0,iHalfW,iHalfH);
  pDynMenuRect->Set(iHalfW+1,0,Attr.X + Attr.W,iHalfH);
  pDynRespRect->Set(0,iHalfH+1,iHalfW,Attr.Y + Attr.H);
  pNoRespRect->Set(iHalfW+1,iHalfH+1,Attr.X+Attr.W,Attr.Y + Attr.H);


  TPen Pen(TColor::Black,1);
  TBrush Brush1(TColor::LtYellow);
  TBrush Brush2(TColor::LtRed);
  TBrush Brush3(TColor::LtBlue);
  TBrush Brush4(TColor::LtCyan);
  DC.SelectObject (Pen);
  DC.SelectObject(Brush1);
  DC.Rectangle (*pSubMenuRect);
  DC.SelectObject(Brush2);
  DC.Rectangle (*pDynMenuRect);
  DC.SelectObject(Brush3);
  DC.Rectangle (*pDynRespRect);
  DC.SelectObject(Brush4);
  DC.Rectangle (*pNoRespRect);
  DC.RestoreObjects();

}


void TCombinedWindow::SetupWindow()
{
  TWindow::SetupWindow();

  // INSERT>> Your code here.

}

TResult TCombinedWindow::EvCommand(uint id, THandle hWndCtl, uint notifyCode)

/* Handles command notificatios send by the menuitems with no response table
   entry defined */

{
  TResult result;
  result = TWindow::EvCommand(id, hWndCtl, notifyCode);

  if (notifyCode == WM_NULL)
  {
   switch (id)
   {
    case CM_MENUITEM5 : CmMenuitem5();
                        break;
    case CM_MENUITEM6 : CmMenuitem6();
                        break;
   }//switch
  }//if
  return result;
}

void
TCombinedWindow::EvCommandEnable(TCommandEnabler& Enabler)
{
  if (CM_MENUITEM5 <= Enabler.Id && Enabler.Id <= CM_MENUITEM6)
  {
    // enable dynamic menu specific item
    Enabler.Enable(true);
  }//if
  else
    TWindow::EvCommandEnable(Enabler);
}


