//----------------------------------------------------------------------------
//  Project Combined
//  University of Mannheim
//  Copyright  1996. All Rights Reserved
//
//  SUBSYSTEM:    Combined Application
//  FILE:         cmbndwnd.h
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TCombinedWindow (TWindow).
//
//----------------------------------------------------------------------------
#if !defined(cmbndwnd_h)              // Sentry, use file only if it's not already included.
#define cmbndwnd_h

#include "cmbndapp.rh"            // Definition of all resources.


#define CM_MENUITEM3 20002
#define CM_MENUITEM4 20003
#define CM_MENUITEM5 20005
#define CM_MENUITEM6 20006

//{{TWindow = TCombinedWindow}}
class TCombinedWindow : public TWindow {
  public:
    TCombinedWindow(TWindow* parent, const char far* title = 0, TModule* module = 0);
    virtual ~TCombinedWindow();

//{{TCombinedWindowVIRTUAL_BEGIN}}
  public:
    virtual void Paint(TDC& dc, bool erase, TRect& rect);
    virtual void SetupWindow();
//{{TCombinedWindowVIRTUAL_END}}

//{{TCombinedWindowRSP_TBL_BEGIN}}
  protected:
    //handler for some menu messages
    void CmMenuitem1();
    void CmMenuitem2();
    void CmMenuitem3();
    void CmMenuitem4();
    void CmMenuitem5();
    void CmMenuitem6();
    void EvRButtonDown(uint modKeys, TPoint& point);
    virtual TResult EvCommand(uint id, THandle hWndCtl, uint notifyCode);
    void EvCommandEnable(TCommandEnabler& Enabler);
//{{TCombinedWindowRSP_TBL_END}}

  //areas where the various menues will appear
  TRect *pSubMenuRect;
  TRect *pDynMenuRect;
  TRect *pDynRespRect;
  TRect *pNoRespRect;

DECLARE_RESPONSE_TABLE(TCombinedWindow);
};    //{{TCombinedWindow}}


#endif  // cmbndwnd_h sentry.
