//----------------------------------------------------------------------------
//  Project SimpleCM
//  University of Mannheim, Germany
//  Copyright  1997 . .
//
//  SUBSYSTEM:    SimpleCM Application
//  FILE:         smplcmad.h
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Class definition for TSimpleCMAboutDlg (TDialog).
//
//----------------------------------------------------------------------------
#if !defined(smplcmad_h)              // Sentry, use file only if it's not already included.
#define smplcmad_h

#include <owl/static.h>

#include "smplcmap.rh"                  // Definition of all resources.


//{{TDialog = TSimpleCMAboutDlg}}
class TSimpleCMAboutDlg : public TDialog {
  public:
    TSimpleCMAboutDlg(TWindow* parent, TResId resId = IDD_ABOUT, TModule* module = 0);
    virtual ~TSimpleCMAboutDlg();

//{{TSimpleCMAboutDlgVIRTUAL_BEGIN}}
  public:
    void SetupWindow();
//{{TSimpleCMAboutDlgVIRTUAL_END}}
};    //{{TSimpleCMAboutDlg}}


// Reading the VERSIONINFO resource.
//
class TProjectRCVersion {
  public:
    TProjectRCVersion(TModule* module);
    virtual ~TProjectRCVersion();

    bool GetProductName(LPSTR& prodName);
    bool GetProductVersion(LPSTR& prodVersion);
    bool GetCopyright(LPSTR& copyright);
    bool GetDebug(LPSTR& debug);

  protected:
    uint8 far*  TransBlock;
    void far*   FVData;

  private:
    // Don't allow this object to be copied.
    //
    TProjectRCVersion(const TProjectRCVersion&);
    TProjectRCVersion& operator = (const TProjectRCVersion&);
};


#endif  // smplcmad_h sentry.
