//----------------------------------------------------------------------------
//  Project SimpleCM
//  University of Mannheim, Germany
//  Copyright  1997 . .
//
//  SUBSYSTEM:    SimpleCM Application
//  FILE:         smplcmwn.cpp
//  AUTHOR:       Mark Caroli
//
//  OVERVIEW
//  ~~~~~~~~
//  Source file for implementation of TSimpleCMWindow (TWindow).
//
//----------------------------------------------------------------------------

#include <owl/pch.h>

#include "smplcmap.h"

#include "smplcmwn.h"

#include <stdio.h>


//
// Build a response table for all messages/commands handled by the application.
//
DEFINE_RESPONSE_TABLE1(TSimpleCMWindow, TWindow)
//{{TSimpleCMWindowRSP_TBL_BEGIN}}
  EV_COMMAND(CM_MENUITEM1, CmMenuitem1),
  EV_COMMAND(CM_MENUITEM2, CmMenuitem2),
//{{TSimpleCMWindowRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{TSimpleCMWindow Implementation}}


//--------------------------------------------------------
// TSimpleCMWindow
// ~~~~~~~~~~
// Construction/Destruction handling.
//
TSimpleCMWindow::TSimpleCMWindow(TWindow* parent, const char far* title, TModule* module)
:
  TWindow(parent, title, module)
{
  // INSERT>> Your constructor code here.

}


TSimpleCMWindow::~TSimpleCMWindow()
{
  Destroy();

  // INSERT>> Your destructor code here.

}

void TSimpleCMWindow::CmMenuitem1()
{
  // INSERT>> Your code here.
 MessageBox ("You' ve selected Item 1","Simple Context Menu");
}


void TSimpleCMWindow::CmMenuitem2()
{
  // INSERT>> Your code here.
 MessageBox ("You' ve selected Item 2","Simple Context Menu");
}


void TSimpleCMWindow::SetupWindow()
{
  TWindow::SetupWindow();

  // INSERT>> Your code here.

 //Create a TMenu instance from the resource script
 TMenu Menu (*GetApplication(),IDM_SIMPLECONTEXTMENU);

 //Use the result to create a TPopupMenu
 TPopupMenu *pPopupMenu = new TPopupMenu (Menu);

 //Assign the context menu
 AssignContextMenu (pPopupMenu);

}

